function [pval, score] = Ftest(y,X,Z)

% This subroutine performs the F-test, comparing the significance of the
% regressions using y=Xb vs y=[X Z]b.
%
% Written by: Rudiyanto Gunawan
% Date: 14 February 2017

[n,K] = size(X);
P = size(Z,2);

% OLS of y = Xb
res = y - X*((X'*X)\X'*y);
L = res'*res;

% OLS of y = [X Z]a
Xhat = [X Z];
res = y - Xhat*((Xhat'*Xhat)\Xhat'*y);
Lhat = res'*res;
s2 = Lhat/(n-K-P);

% F-test comparing the two model
score = ((L-Lhat)/P)/s2;
pval = 1-fcdf(score,P,n-K-P);